*Title: Removing /public/index.php from URL-s
*Slug: clean-url

================================================================

By default, activeCollab uses URL-s containing <{path}>/public/index.php<{/path}> in order to avoid having <{code}>mod_rewrite<{/code}> as a system requirement. If, from some reason, this system does not work (for instance, you receive "No input file specified error") or you just want to have a 100% clean URL, please follow the instructions bellow to implement it and disable default URL-s.

First create a file named <{code}>.htaccess<{/code}> in the folder where activeCollab is installed, and add these lines:

<{code}>Options -Indexes
<IfModule mod_rewrite.c>
  RewriteEngine On

  RewriteCond %{REQUEST_FILENAME} -f [OR]
  RewriteCond %{REQUEST_FILENAME} -d
  RewriteRule ^(.+) - [PT,L]

  RewriteRule ^assets/(.*)$ public/assets/$1 [L]
  RewriteRule ^avatars/(.*)$ public/avatars/$1 [L]
  RewriteRule ^logos/(.*)$ public/logos/$1 [L]
  RewriteRule ^notebook_covers/(.*)$ public/notebook_covers/$1 [L]
  RewriteRule ^template_covers/(.*)$ public/template_covers/$1 [L]
  RewriteRule ^projects_icons/(.*)$ public/projects_icons/$1 [L]
  RewriteRule ^proxy.php$ public/proxy.php [QSA,L]
  RewriteRule ^sync.php$ public/sync.php [QSA,L]
  RewriteRule ^$ public/index.php [QSA,L]
  RewriteRule ^(.*) public/index.php?path_info=$1 [QSA,L]
</IfModule><{/code}>

Now open <{path}>config/config.php<{/path}> and update the value of ROOT_URL to exclude /public from the link. For example, if the original URL was:

<{code}>define('ROOT_URL', 'http://projects.example.com/public');<{/code}>

or:

<{code}>const ROOT_URL = 'http://projects.example.com/public';<{/code}>

Edit this line, and set it to:

<{code}>const ROOT_URL = 'http://projects.example.com';<{/code}>

After you have made this declaration (not earlier, it will not work), add the following three lines:

<{code highlight=php}>define('URL_BASE', ROOT_URL . '/');
define('ASSETS_URL', ROOT_URL . '/public/assets');
define('PATH_INFO_THROUGH_QUERY_STRING', false);<{/code}>

Finally, clear the cache folder, so that activeCollab can pick up new URL-s instead of using the old, cached ones. To clear the cache, use your FTP client and navigate to the <{path}>/cache<{/path}> folder of your activeCollab and remove all .php files that are stored there.

<{note title="Rewrite Rules"}>If you are using IIS7 or nginx server, here are some tips that can help you set up clean URL-s:

- for IIS7 users - IIS7 rewrite module features a tool that lets you easily import Apache mod_rewrite rules. Please check <a href="http://learn.iis.net/page.aspx/470/importing-apache-modrewrite-rules/">this article</a> for more details.
- for nginx users: please use the following rules to set up clean URL-s in your activeCollab:

<{code}>if (!-e $request_filename) {
    rewrite ^avatars/(.*)$ /public/avatars/$1 last;
    rewrite ^logos/(.*)$ /public/logos/$1 last;
    rewrite ^notebook_pages/(.*)$ /public/notebook_pages/$1 last;
    rewrite ^projects_icons/(.*)$ /public/projects_icons/$1 last;
    rewrite ^proxy.php$ public/proxy.php last;
    rewrite ^sync.php$ public/sync.php last
    rewrite ^$ /public/index.php last;
    rewrite ^(.*) /public/index.php?path_info=$1 last;
}<{/code}><{/note}>

To test your new setup, navigate through your activeCollab and check if the links are updated.